#!/bin/bash
input=$(cat)

MODEL=$(echo "$input" | jq -r '.model.display_name')
CONTEXT_SIZE=$(echo "$input" | jq -r '.context_window.context_window_size')
USAGE=$(echo "$input" | jq '.context_window.current_usage')

if [ "$USAGE" != "null" ]; then
    CURRENT_TOKENS=$(echo "$USAGE" | jq '.input_tokens + .cache_creation_input_tokens + .cache_read_input_tokens')
    PERCENT_USED=$((CURRENT_TOKENS * 100 / CONTEXT_SIZE))

    # Generate progress bar (10 characters wide)
    FILLED=$((PERCENT_USED / 10))
    EMPTY=$((10 - FILLED))
    BAR=$(printf '█%.0s' $(seq 1 $FILLED))$(printf '░%.0s' $(seq 1 $EMPTY))

    printf "[%s] [%s] %d%%" "$MODEL" "$BAR" "$PERCENT_USED"
else
    # Empty progress bar
    BAR="░░░░░░░░░░"
    printf "[%s] [%s] 0%%" "$MODEL" "$BAR"
fi
