# Kopia Backup Server Installation

This repository contains an automated installation script for setting up [Kopia](https://kopia.io/) backup server on Debian 13 LXC containers.

## Overview

Kopia is a fast and secure open-source backup/restore tool that allows you to create encrypted snapshots of your data. This script automates the installation and configuration of Kopia server with systemd integration, allowing you to manage backups through a web-based interface.

## Prerequisites

- Debian 13 LXC container (or compatible Debian-based system)
- Root access (or sudo privileges)
- Internet connectivity
- At least 512MB RAM (1GB+ recommended)
- Network access to the container on port 51515

## Installation

### Quick Start

1. Run the installation script as root:

```bash
sudo ./install-kopia.sh
```

The script will automatically:
- Set the system timezone to Europe/Paris
- Install required dependencies (curl, gnupg)
- Add Kopia's official GPG signing key
- Configure Kopia's APT repository
- Install Kopia
- Create and configure a systemd service
- Enable and start the Kopia server

2. Once installation completes, access the web UI:

```
http://your-container-ip:51515
```

## What the Script Does

The installation script performs the following steps:

1. **Timezone Configuration**: Sets system timezone to `Europe/Paris` using `timedatectl`

2. **Dependencies**: Installs required packages:
   - `curl` - for downloading the GPG key
   - `gnupg` - for GPG key management

3. **Repository Setup**:
   - Downloads Kopia's GPG signing key from https://kopia.io/signing-key
   - Saves it to `/etc/apt/keyrings/kopia-keyring.gpg`
   - Adds Kopia repository to `/etc/apt/sources.list.d/kopia.list`

4. **Package Installation**: Installs the latest stable version of Kopia

5. **Systemd Service**: Creates `/etc/systemd/system/kopia.service` with:
   - Server running as `root` user
   - Address: `0.0.0.0:51515` (accessible on all network interfaces)
   - Flags: `--insecure --without-password` (for easy initial setup)
   - Auto-restart on failure

6. **Service Activation**: Enables and starts the Kopia service

## Post-Installation Steps

After running the script, follow these steps to start using Kopia:

### 1. Access the Web Interface

Open your browser and navigate to:
```
http://your-container-ip:51515
```

### 2. Initialize or Connect to a Repository

On first access, you'll be prompted to either:

**Option A: Create a new repository**
- Choose a storage backend (filesystem, S3, Google Cloud Storage, etc.)
- For local filesystem: specify a path like `/var/backups/kopia-repo`
- Set encryption password (keep this safe!)

**Option B: Connect to an existing repository**
- Choose the same storage backend as your existing repo
- Provide connection details
- Enter the repository password

### 3. Configure Backup Policies

Once connected:
- Define what to back up (snapshots)
- Set retention policies (how long to keep backups)
- Configure scheduling (if desired)
- Start your first backup

## Systemd Service Management

### Service Commands

```bash
# Check service status
systemctl status kopia

# Stop the service
systemctl stop kopia

# Start the service
systemctl start kopia

# Restart the service
systemctl restart kopia

# Disable service (prevent auto-start on boot)
systemctl disable kopia

# Enable service (auto-start on boot)
systemctl enable kopia
```

### View Logs

```bash
# View recent logs
journalctl -u kopia

# Follow logs in real-time
journalctl -u kopia -f

# View logs from last boot
journalctl -u kopia -b
```

## Configuration

### Service Configuration File

The systemd service file is located at:
```
/etc/systemd/system/kopia.service
```

Current configuration:
```ini
ExecStart=/usr/bin/kopia server start --insecure --address=0.0.0.0:51515 --without-password
```

### Command-Line Flags Explained

- `--insecure`: Runs server without TLS/HTTPS encryption
- `--address=0.0.0.0:51515`: Binds to all network interfaces on port 51515
- `--without-password`: Disables password authentication

### Customizing the Service

To modify the service configuration:

1. Edit the service file:
```bash
nano /etc/systemd/system/kopia.service
```

2. Reload systemd:
```bash
systemctl daemon-reload
```

3. Restart the service:
```bash
systemctl restart kopia
```

## Security Considerations

**Important**: The default configuration is designed for easy initial setup and testing. For production use, you should secure your Kopia installation.

### Recommended Security Enhancements

1. **Enable Password Authentication**

   Remove the `--without-password` flag and set credentials:
   ```bash
   # Edit the service file
   ExecStart=/usr/bin/kopia server start --insecure --address=0.0.0.0:51515 --server-password=YourSecurePassword
   ```

2. **Enable TLS/HTTPS**

   Remove the `--insecure` flag and provide TLS certificates:
   ```bash
   ExecStart=/usr/bin/kopia server start \
     --address=0.0.0.0:51515 \
     --tls-cert-file=/path/to/cert.pem \
     --tls-key-file=/path/to/key.pem \
     --server-password=YourSecurePassword
   ```

3. **Restrict Network Access**

   Bind to specific interface instead of `0.0.0.0`:
   ```bash
   # Listen only on localhost
   --address=127.0.0.1:51515

   # Listen only on specific interface
   --address=192.168.1.100:51515
   ```

4. **Firewall Configuration**

   Restrict access to port 51515:
   ```bash
   # Example with ufw
   ufw allow from 192.168.1.0/24 to any port 51515
   ```

5. **Use htpasswd Authentication**

   Create password file:
   ```bash
   # Install apache2-utils
   apt-get install apache2-utils

   # Create password file
   htpasswd -c /root/kopia-users.htpasswd username

   # Update service to use htpasswd
   ExecStart=/usr/bin/kopia server start \
     --htpasswd-file=/root/kopia-users.htpasswd \
     --address=0.0.0.0:51515
   ```

## Repository Management

### Common Kopia Commands

```bash
# Show repository status
kopia repository status

# List snapshots
kopia snapshot list

# Create manual snapshot
kopia snapshot create /path/to/data

# Restore snapshot
kopia snapshot restore <snapshot-id> /path/to/restore

# Show repository statistics
kopia repository stats
```

### Repository Types

Kopia supports various storage backends:

- **Filesystem**: Local or mounted network storage
- **S3**: Amazon S3 or S3-compatible services
- **Google Cloud Storage**: GCS buckets
- **Azure Blob Storage**: Microsoft Azure
- **B2**: Backblaze B2
- **SFTP**: Remote servers via SSH
- **WebDAV**: WebDAV servers

## Troubleshooting

### Service Won't Start

1. Check service status and logs:
   ```bash
   systemctl status kopia
   journalctl -u kopia -n 50
   ```

2. Verify Kopia installation:
   ```bash
   which kopia
   kopia --version
   ```

3. Test manual start:
   ```bash
   /usr/bin/kopia server start --insecure --address=0.0.0.0:51515 --without-password
   ```

### Port Already in Use

If port 51515 is already in use:

1. Check what's using the port:
   ```bash
   lsof -i :51515
   netstat -tulpn | grep 51515
   ```

2. Change the port in the service file:
   ```bash
   # Edit /etc/systemd/system/kopia.service
   ExecStart=/usr/bin/kopia server start --insecure --address=0.0.0.0:52515 --without-password
   ```

### Cannot Access Web UI

1. Verify service is running:
   ```bash
   systemctl is-active kopia
   ```

2. Check if port is listening:
   ```bash
   ss -tulpn | grep 51515
   ```

3. Verify firewall rules:
   ```bash
   iptables -L -n | grep 51515
   ufw status
   ```

4. Test from container:
   ```bash
   curl http://localhost:51515
   ```

### Repository Not Found Error

If the service starts but shows "repository not found":

This is **expected behavior** on first run. You need to initialize or connect to a repository through the web UI at `http://your-ip:51515`.

### Permission Denied Errors

If you encounter permission issues:

1. Ensure repository directory has correct permissions:
   ```bash
   chown -R root:root /path/to/repo
   chmod -R 700 /path/to/repo
   ```

2. Verify service runs as root:
   ```bash
   systemctl show kopia | grep User
   ```

## Additional Resources

- **Official Documentation**: https://kopia.io/docs/
- **GitHub Repository**: https://github.com/kopia/kopia
- **Community Forum**: https://kopia.discourse.group/
- **Repository Server Guide**: https://kopia.io/docs/repository-server/
- **Command Reference**: https://kopia.io/docs/reference/command-line/

## Uninstallation

To completely remove Kopia:

```bash
# Stop and disable service
systemctl stop kopia
systemctl disable kopia

# Remove service file
rm /etc/systemd/system/kopia.service
systemctl daemon-reload

# Remove Kopia package
apt-get remove --purge kopia

# Remove repository configuration
rm /etc/apt/sources.list.d/kopia.list
rm /etc/apt/keyrings/kopia-keyring.gpg

# Update package lists
apt-get update
```

Note: This does not delete your backup repositories. Repository data must be manually deleted if desired.

## License

This installation script is provided as-is for convenience. Kopia itself is licensed under the Apache License 2.0.

## Support

For issues with:
- **This script**: Check the Troubleshooting section above
- **Kopia software**: Visit https://kopia.discourse.group/
- **LXC containers**: Consult your container platform documentation
